/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.inventory;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import slimeknights.mantle.util.BlockEntityHelper;

public class BaseContainerMenu<TILE extends BlockEntity>
extends AbstractContainerMenu {
    public static double MAX_DISTANCE = 64.0;
    public static int BASE_Y_OFFSET = 84;
    @Nullable
    protected final TILE tile;
    @Nullable
    protected final Inventory inv;
    protected int playerInventoryStart = -1;

    protected BaseContainerMenu(MenuType<?> type, int id, @Nullable Inventory inv, @Nullable TILE tile) {
        super(type, id);
        this.inv = inv;
        this.tile = tile;
    }

    @Nullable
    public TILE getTile() {
        return this.tile;
    }

    public void syncOnOpen(ServerPlayer playerOpened) {
        ServerLevel server = playerOpened.m_183503_();
        for (Player player : server.m_6907_()) {
            if (player == playerOpened || !(player.f_36096_ instanceof BaseContainerMenu) || !this.sameGui((BaseContainerMenu)player.f_36096_)) continue;
            this.syncWithOtherContainer((BaseContainerMenu)player.f_36096_, playerOpened);
            return;
        }
        this.syncNewContainer(playerOpened);
    }

    protected void syncWithOtherContainer(BaseContainerMenu otherContainer, ServerPlayer player) {
    }

    protected void syncNewContainer(ServerPlayer player) {
    }

    public boolean sameGui(BaseContainerMenu otherContainer) {
        if (this.tile == null) {
            return false;
        }
        return this.tile == otherContainer.tile;
    }

    public boolean m_6875_(Player playerIn) {
        if (this.tile == null) {
            return true;
        }
        if (!this.tile.m_58901_()) {
            Level world = this.tile.m_58904_();
            if (world == null) {
                return false;
            }
            return world.m_46749_(this.tile.m_58899_());
        }
        return false;
    }

    public NonNullList<ItemStack> m_38927_() {
        return super.m_38927_();
    }

    protected void addInventorySlots() {
        if (this.inv != null) {
            this.addInventorySlots(this.inv);
        }
    }

    protected int getInventoryXOffset() {
        return 8;
    }

    protected int getInventoryYOffset() {
        return BASE_Y_OFFSET;
    }

    protected void addInventorySlots(Inventory inv) {
        int slotY;
        int yOffset = this.getInventoryYOffset();
        int xOffset = this.getInventoryXOffset();
        int start = this.f_38839_.size();
        for (slotY = 0; slotY < 3; ++slotY) {
            for (int slotX = 0; slotX < 9; ++slotX) {
                this.m_38897_(new Slot((Container)inv, slotX + slotY * 9 + 9, xOffset + slotX * 18, yOffset + slotY * 18));
            }
        }
        yOffset += 58;
        for (slotY = 0; slotY < 9; ++slotY) {
            this.m_38897_(new Slot((Container)inv, slotY, xOffset + slotY * 18, yOffset));
        }
        this.playerInventoryStart = start;
    }

    protected Slot m_38897_(Slot slotIn) {
        if (this.playerInventoryStart >= 0) {
            throw new IllegalStateException("BaseContainer: Player inventory has to be last slots. Add all slots before adding the player inventory.");
        }
        return super.m_38897_(slotIn);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        if (this.playerInventoryStart < 0) {
            return ItemStack.f_41583_;
        }
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            int end = this.f_38839_.size();
            if (index < this.playerInventoryStart ? !this.m_38903_(itemstack1, this.playerInventoryStart, end, true) : !this.m_38903_(itemstack1, 0, this.playerInventoryStart, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        boolean ret = this.mergeItemStackRefill(stack, startIndex, endIndex, useEndIndex);
        if (!stack.m_41619_() && stack.m_41613_() > 0) {
            ret |= this.mergeItemStackMove(stack, startIndex, endIndex, useEndIndex);
        }
        return ret;
    }

    protected boolean mergeItemStackRefill(ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        if (stack.m_41613_() <= 0) {
            return false;
        }
        boolean flag1 = false;
        int k = startIndex;
        if (useEndIndex) {
            k = endIndex - 1;
        }
        if (stack.m_41753_()) {
            while (stack.m_41613_() > 0 && (!useEndIndex && k < endIndex || useEndIndex && k >= startIndex)) {
                Slot slot = (Slot)this.f_38839_.get(k);
                ItemStack itemstack1 = slot.m_7993_();
                if (!itemstack1.m_41619_() && itemstack1.m_41720_() == stack.m_41720_() && ItemStack.m_41658_((ItemStack)stack, (ItemStack)itemstack1) && this.m_5882_(stack, slot)) {
                    int limit;
                    int l = itemstack1.m_41613_() + stack.m_41613_();
                    if (l <= (limit = Math.min(stack.m_41741_(), slot.m_5866_(stack)))) {
                        stack.m_41764_(0);
                        itemstack1.m_41764_(l);
                        slot.m_6654_();
                        flag1 = true;
                    } else if (itemstack1.m_41613_() < limit) {
                        stack.m_41774_(limit - itemstack1.m_41613_());
                        itemstack1.m_41764_(limit);
                        slot.m_6654_();
                        flag1 = true;
                    }
                }
                if (useEndIndex) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        return flag1;
    }

    protected boolean mergeItemStackMove(ItemStack stack, int startIndex, int endIndex, boolean useEndIndex) {
        if (stack.m_41613_() <= 0) {
            return false;
        }
        boolean flag1 = false;
        int k = useEndIndex ? endIndex - 1 : startIndex;
        while (!useEndIndex && k < endIndex || useEndIndex && k >= startIndex) {
            Slot slot = (Slot)this.f_38839_.get(k);
            ItemStack itemstack1 = slot.m_7993_();
            if (itemstack1.m_41619_() && slot.m_5857_(stack) && this.m_5882_(stack, slot)) {
                int limit = slot.m_5866_(stack);
                ItemStack stack2 = stack.m_41777_();
                if (stack2.m_41613_() > limit) {
                    stack2.m_41764_(limit);
                    stack.m_41774_(limit);
                } else {
                    stack.m_41764_(0);
                }
                slot.m_5852_(stack2);
                slot.m_6654_();
                flag1 = true;
                if (stack.m_41619_()) break;
            }
            if (useEndIndex) {
                --k;
                continue;
            }
            ++k;
        }
        return flag1;
    }

    @Nullable
    public static <TILE extends BlockEntity> TILE getTileEntityFromBuf(@Nullable FriendlyByteBuf buf, Class<TILE> type) {
        if (buf == null) {
            return null;
        }
        return (TILE)((BlockEntity)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> BlockEntityHelper.get(type, (BlockGetter)Minecraft.m_91087_().f_91073_, buf.m_130135_()).orElse(null)));
    }
}

